<?php

namespace App\Http\Controllers;

use App\Http\Resources\GameStatusResource;
use App\Models\GameStatus;
use App\Models\User;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class GameStatusController extends Controller
{
    public function getGameStatus(Request $request) {
        //todo Добавить валидатор по типам данных полей

        // Проверяем, что запрос имеет формат JSON
        if (!$request->isJson()) {
            return response()->json(['error' => 'Неверный формат запроса'], 400);
        }

        // Проверяем наличие ключа 'user_id' в запросе
        if (!$request->has('user_id')) {
            return response()->json(['error' => 'Отсутствует ID'], 400);
        }

        $user_id = $request->input('user_id');
        $user = User::firstOrCreate(['user_id' => $user_id]);
        $gameStatus = GameStatus::firstOrCreate(['user_id' => $user->user_id]);
        $gameStatus->refresh();

        return new GameStatusResource($gameStatus);
    }

    public function update(Request $request, $user_id) {
        //todo Добавить валидатор по типам данных полей
        try {
            $gameStatus = GameStatus::where('user_id', $user_id)->firstOrFail();
            $gameStatus->update(
                $request->all()
            );
            return new GameStatusResource($gameStatus);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Отсутствует пользователь с таким id'], 404);
        }
    }
}
