<?php

namespace App\Http\Controllers;

use App\Http\Resources\PrizeResource;
use App\Models\GameStatus;
use App\Models\Prize;
use App\Models\User;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class PrizeController extends Controller
{
    public function getPrize(Request $request) {
        // Проверяем, что запрос имеет формат JSON
        if (!$request->isJson()) {
            return response()->json(['error' => ['message' => 'Неверный формат запроса']], 400);
        }

        // Проверяем наличие ключа 'user_id' в запросе
        if (!$request->has('user_id')) {
            return response()->json(['error' => ['message' => 'Отсутствует ID']], 400);
        }

        $user_id = $request->input('user_id');
        try {
            $user = User::where('user_id', $user_id)->firstOrFail();
            $gameStatus = GameStatus::where('user_id', $user_id)->first();
            if (!is_null($gameStatus->prize) && !is_null($user->prize)) {
                return response()->json(['error' => ['message' => 'Приз уже взят']], 400);
            } else {
                $prize = Prize::where('active', true)->inRandomOrder()->first();
                if (!is_null($prize->count)) {
                    $prize->count -= 1;
                    if($prize->count === 0) {
                        $prize->active = false;
                    }
                    $prize->save();
                }
                $gameStatus->prize = $prize->title;
                $user->prize = $prize->title;
                $gameStatus->save();
                $user->save();
                return new PrizeResource($prize);
            }
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => ['message' => 'Отсутствует пользователь с таким id']], 400);
        }
    }
}
