<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->unique()->nullable(false);
            $table->integer('comrades')->default(6);
            $table->integer('director')->default(8);
            $table->integer('psychological')->default(8);
            $table->integer('effectiveness')->default(10);
            $table->boolean('needGreetings')->default(true);
            $table->longText('complitedActivities')->default('[]');
            $table->string('achievements')->default('[]');
            $table->string('prize')->nullable()->default(null);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_statuses');
    }
};
