<?php

namespace Database\Seeders;

use App\Models\Prize;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PrizesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $prizes = [
            [
                'title'=>'Стикерпак',
                'description' => 'Класс! Теперь у&nbsp;тебя будет <a style="text-decoration: underline" href="https://t.me/addstickers/InternOffice">стикерпак</a> на&nbsp;случай важных переговоров.'
            ],
            [
                'title'=>'Обои',
                'description' => 'Когда у&nbsp;тебя есть личный девиз, ты&nbsp;всегда добиваешься успехов. <a style="text-decoration: underline" href="https://clck.ru/36r3Pe">Скачивай обои</a> с&nbsp;мотивирующими цитатами и&nbsp;стремись к&nbsp;своей мечте. Всё получится!'
            ],
            [
                'title'=>'Игрушка капибара в&nbsp;платочке',
                'description' => 'Ну&nbsp;какая милаха тебе достанется! Скоро мы свяжемся&nbsp;с&nbsp;тобой по&nbsp;зарегистрированной почте и&nbsp;расскажем, как получить подарок.',
                'count' => 10
            ],
            [
                'title'=>'Доступ к&nbsp;курсу',
                'description' => 'Тебе повезло! Ты&nbsp;можешь получить карьерную консультацию после прохождения этого <a style="text-decoration: underline" href="https://rsv.ru/education/courses/1/1063/">курса</a>. Осталось только запланировать начало обучения.'
            ],
            [
                'title'=>'Промокод «ЛитРеса»',
                'description' => 'Сила в&nbsp;знаниях, а&nbsp;знания&nbsp;&mdash; в&nbsp;книгах. Тебе повезло, ведь ты&nbsp;получаешь доступ ко&nbsp;всей электронной библиотеке &laquo;ЛитРеса&raquo;. Просто <a href="https://www.litres.ru/?rsv2023dg=&utm_source=rsv2023dg&utm_medium=cross&utm_campaign=rsv2023dg&from=kponline">используй промокод</a>: GIFTBOOK2023'
            ]
        ];

        foreach ($prizes as $prize) {
            Prize::create(
                $prize
            );
        }
    }
}
