<?php

namespace Tests\Feature;

use Database\Seeders\GameStatusTestSeeder;
use Database\Seeders\PromocodesSeederTest;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Tests\TestCase;

class GameStatusTest extends TestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    use WithoutMiddleware;
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        $this->seed(GameStatusTestSeeder::class);
    }

    // Отправляем POST-запрос на роут /api/game_status не в в формате JSON
    public function testNotJsonRequest(): void
    {
        $response = $this->post('/api/game_status');

        $response->assertStatus(400);
    }

    // Отправляем POST-запрос на роут /api/game_status без user_id
    public function testMissingUserRequest(): void
    {
        $data = [];

        $response = $this->json('POST', '/api/game_status', $data);

        $response->assertStatus(400);
    }

    // Отправляем валидный POST-запрос на роут /api/game_status
    public function testValidJsonRequest(): void
    {
        $data = [
            'user_id' => 1236,
        ];

        // Отправляем POST-запрос на роут /api/game_status с данными в формате JSON
        $response = $this->json('POST', '/api/game_status', $data);

        $response->assertStatus(201)->assertJsonStructure([
            'data' => [
                "id",
                "user_id",
                "comrades",
                "director",
                "psychological",
                "effectiveness",
                "needGreetings",
                "complitedActivities",
                "achievements",
                "prize",
                "created_at",
                "updated_at"
            ]
        ]);
    }

    public function testUndefinedIDUpdate(): void{
        // Отправляем POST-запрос на роут /api/game_status с данными в формате JSON
        $response = $this->json('PUT', '/api/game_status/7890');

        $response->assertStatus(404);
    }

    public function testValidIDUpdate(): void{
        $data = [
            'comrades' => 12,
        ];

        // Отправляем POST-запрос на роут /api/game_status с данными в формате JSON
        $response = $this->json('PUT', '/api/game_status/123456', $data);

        $response->assertStatus(200)->assertJsonStructure([
            'data' => [
                "id",
                "user_id",
                "comrades",
                "director",
                "psychological",
                "effectiveness",
                "needGreetings",
                "complitedActivities",
                "achievements",
                "prize",
                "created_at",
                "updated_at"
            ]
        ])->assertJson([
            'data'=>[
                'comrades' => 12
            ]
        ]);
    }
}
