<?php

namespace Tests\Feature;

use Database\Seeders\GameStatusTestSeeder;
use Database\Seeders\PrizesSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Tests\TestCase;

class PrizeTest extends TestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    use WithoutMiddleware;
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        $this->seed(PrizesSeeder::class);
        $this->seed(GameStatusTestSeeder::class);
    }
    // Отправляем PUT-запрос на роут /api/game_status не в в формате JSON
    public function testNotJsonRequest(): void
    {
        $response = $this->post('/api/get_prize');

        $response->assertStatus(400);
    }

    // Отправляем PUT-запрос на роут /api/get_prize без user_id
    public function testMissingUserRequest(): void
    {
        $data = [];

        $response = $this->json('PUT', '/api/get_prize', $data);

        $response->assertStatus(400);
    }

    // Отправляем валидный PUT-запрос на роут /api/get_prize
    public function testValidJsonRequest(): void
    {
        $data = [
            'user_id' => 123456,
        ];

        // Отправляем PUT-запрос на роут /api/game_status с данными в формате JSON
        $response = $this->json('PUT', '/api/get_prize', $data);

        dd(json_decode($response->content()));

        $response->assertStatus(201);
    }

    // Отправляем сыгравшего пользователя PUT-запрос на роут /api/get_prize
    public function testAlreadyHavePrizeJsonRequest(): void
    {
        $data = [
            'user_id' => 7890,
        ];

        // Отправляем PUT-запрос на роут /api/game_status с данными в формате JSON
        $response = $this->json('PUT', '/api/get_prize', $data);
        dd(json_decode($response->content()));
        $response->assertStatus(400);
    }
}
